-- mods/silver/init.lua
-- ===================
-- See LICENSE.txt for licensing and README.md for other information.

-- load support for intllib
local modpath = minetest.get_modpath(minetest.get_current_modname())
local S = minetest.get_translator("silver")

-- Lapis Lazuli Ore
minetest.register_node("silver:stone_with_silver", {
	description = S("silver Ore"),
	tiles = {"default_stone.png^silver_mineral_silver.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'silver:silver 2'},  --The first and second drops ever
			},
			{
				items = {'silver:silver'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'silver:silver'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'silver:silver'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Item
minetest.register_craftitem("silver:silver", {
	description = S("silver"),
	inventory_image = "silver.png",
})

-- Lapis Block
minetest.register_node("silver:silverblock", {
	description = S("silver Block"),
	tiles = {"silver_silverblock.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Block Crafting
minetest.register_craft({
	output = 'silver:silver',
	recipe = {
		{'silver:silver', 'silver:silver', 'silver:silver'},
		{'silver:silver', 'silver:silver', 'silver:silver'},
		{'silver:silver', 'silver:silver', 'silver:silver'},
	}
})

-- Lapis Items from Lapis Block Crafting
minetest.register_craft({
	output = 'silver:silver 9',
	recipe = {
		{'silver:silver'},
	}
})

-- Ore generation
-- -128 <-> -255
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "silver:stone_with_silver",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 31000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "silver:stone_with_silver",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 31000,
})


